package org.msh.tb.export_rest.core;

import java.util.Arrays;
import java.util.List;

/**
 * Expects a reader with one key and one single value. The value will be used
 * to the corresponding column with a true or false value
 * <p>
 * Created by rmemoria on 20/7/17.
 */
public class ValueGroupBlockReader extends BlockReaderImpl {

    private BlockReader reader;
    private List<String> columns;
    private Integer valueColIndex;

    public ValueGroupBlockReader(BlockReader reader, List<String> columns) {
        this.reader = reader;
        this.columns = columns;
    }

    public ValueGroupBlockReader(BlockReader reader, List<String> columns, int valueColIndex) {
        this.reader = reader;
        this.columns = columns;
        this.valueColIndex = valueColIndex;
    }

    @Override
    public List<String> getColumns() {
        return columns;
    }

    @Override
    protected Record readNext() {
        Record rec = reader.current();
        if (reader.current() == null) {
            return null;
        }

        Object key = rec.getKey();
        Object[] values = new Object[columns.size()];

        while (rec != null && key.equals(rec.getKey())) {
            Object item = rec.getValues().get(0);
            int index = columns.indexOf(item);

            if (index >= 0) {
                Object cellValue = valueColIndex != null ? rec.getValues().get(valueColIndex) : "X";
                values[index] = cellValue;
            }

            rec = reader.next();
        }

        List lst = Arrays.asList(values);
        Record grpRecord = new Record(key, lst);

        return grpRecord;
    }
}
